<?php

namespace Ptb\Pace\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;
use Ptb\Pace\Enums\TaskStatus;

class PaceTask extends Model
{
    use SoftDeletes;

    protected $guarded = [];
    protected $casts = [
        'task_reference' => 'string',
        'task_description' => 'string',
        'task_status' => TaskStatus::class,
        'task_estimate_number' => 'string',
        'task_job_number' => 'string',
        'task_job_type_id' => 'integer',
        'task_sub_job_type_id' => 'integer',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
        'deleted_at' => 'datetime',
    ];

    public function parts(): HasMany
    {
        return $this->hasMany(PaceTaskPart::class);
    }

}
