<?php

namespace Ptb\Pace\Data;

use Carbon\Carbon;
use Ptb\Pace\Castables\ToCarbon;
use Ptb\Pace\Concerns\HasApiMethods;
use Ptb\Pace\Transformers\AsCarbon;
use Spatie\LaravelData\Attributes\WithCastable;
use Spatie\LaravelData\Attributes\WithTransformer;
use Spatie\LaravelData\Data;


class AttachmentCategory extends Data
{
    use HasApiMethods;

    protected static string $apiObjectName = 'attachmentCategory';
    protected static int $apiCacheFilterExpire = 86400;

    public function __construct(
        public bool|null   $availableInShippingApp,
        public mixed       $id,
        public string|null $ioID,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $lastModified,
        public string|null $name,
        public string|null $object,
        public string|null $objectCategory,
        public mixed       $sourceOrganizationCompany,
        public array|null  $tags,
        public int|null    $templateLine,
        public string|null $type,
    )
    {
    }

}
