<?php

namespace Ptb\Pace\Nova;

use Laravel\Nova\Fields\BelongsTo;
use Laravel\Nova\Fields\Boolean;
use Laravel\Nova\Fields\FormData;
use Laravel\Nova\Fields\Select;
use Laravel\Nova\Fields\Text;
use Laravel\Nova\Http\Requests\NovaRequest;
use Laravel\Nova\Panel;
use Laravel\Nova\Resource;
use Ptb\Pace\Data\AddressFormat;
use Ptb\Pace\Data\Contact;
use Ptb\Pace\Data\DeDupeType;
use Ptb\Pace\Data\Distribution;
use Ptb\Pace\Data\ExtraStock;
use Ptb\Pace\Data\InsertType;
use Ptb\Pace\Data\ListSource;
use Ptb\Pace\Data\MailingClass;
use Ptb\Pace\Data\MailingSize;
use Ptb\Pace\Data\MailingTabs;
use Ptb\Pace\Data\MailingType;
use Ptb\Pace\Data\PermitBilling;
use Ptb\Pace\Data\PermitPrint;
use Ptb\Pace\Data\PermitUsed;
use Ptb\Pace\Data\PostageType;
use Ptb\Pace\Data\PrintCase;
use Ptb\Pace\Data\PrintType;
use Ptb\Pace\Data\ReturnPrint;
use Ptb\Pace\Models\PaceAutomation;
use Ptb\Pace\Models\PaceAutomationMailing;

class AutomationMailing extends Resource
{
    public static $displayInNavigation = false;
    public static $group = 'Integrations';
    public static $model = PaceAutomationMailing::class;
    public static $title = 'automation.job_product_type.description';
    public static $search = [];

    public function fields(NovaRequest $request)
    {
        return [
            BelongsTo::make('Automation', 'automation', Automation::class),
            Select::make('Mailing Type', 'mailing_type')
                ->options(fn() => MailingType::active()->toCollection()->pluck('description', 'id'))
                ->displayUsingLabels()
                ->hideFromIndex()
                ->nullable(),
            Select::make('Mailing Size', 'mailing_size')
                ->options(fn() => MailingSize::active()->toCollection()->pluck('description', 'id'))
                ->displayUsingLabels()
                ->hideFromIndex()
                ->nullable(),
            Select::make('Mailing Class', 'mailing_class')
                ->options(fn() => MailingClass::active()->toCollection()->pluck('description', 'id'))
                ->displayUsingLabels()
                ->hideFromIndex()
                ->nullable(),
            Select::make('Mailing Tabs', 'mailing_tabs')
                ->options(fn() => MailingTabs::active()->toCollection()->pluck('description', 'id'))
                ->displayUsingLabels()
                ->hideFromIndex()
                ->nullable(),
            Select::make('Insert Type', 'insert_type')
                ->options(fn() => InsertType::active()->toCollection()->pluck('description', 'id'))
                ->displayUsingLabels()
                ->hideFromIndex()
                ->nullable(),
            Boolean::make('Aspect Ratio', 'aspect_ratio')->hideFromIndex(),
            Boolean::make('Barcode', 'barcode')->hideFromIndex(),


            Panel::make('Processing of List', [
                Select::make('List Source', 'list_source')
                    ->options(fn() => ListSource::active()->toCollection()->pluck('description', 'id'))
                    ->displayUsingLabels()
                    ->hideFromIndex()
                    ->nullable(),
                Select::make('Distribution', 'distribution')
                    ->options(fn() => Distribution::active()->toCollection()->pluck('description', 'id'))
                    ->displayUsingLabels()
                    ->hideFromIndex()
                    ->nullable(),
                Boolean::make('CASS List', 'cass_list')->hideFromIndex(),
                Boolean::make('NCOA List', 'ncoa_list')->hideFromIndex(),
                Boolean::make('Remove Undeliverable', 'remove_undeliverable')->hideFromIndex(),
                Boolean::make('Remove Duplicate Address', 'remove_duplicate_address')->hideFromIndex(),
                Boolean::make('Duplicate Address', 'duplicate_address')->hideFromIndex(),
                Boolean::make('Clean List', 'clean_list')->hideFromIndex(),
                Select::make('How To De-Dupe', 'de_dupe_type')
                    ->options(fn() => DeDupeType::active()->toCollection()->pluck('description', 'id'))
                    ->displayUsingLabels()
                    ->hideFromIndex()
                    ->nullable(),
                Select::make('Postage Type', 'postage_type')
                    ->options(fn() => PostageType::active()->toCollection()->pluck('description', 'id'))
                    ->displayUsingLabels()
                    ->hideFromIndex()
                    ->nullable(),
                Select::make('Permit Used', 'permit_used')
                    ->options(fn() => PermitUsed::active()->toCollection()->pluck('description', 'id'))
                    ->displayUsingLabels()
                    ->hideFromIndex()
                    ->nullable(),
                Select::make('Permit Billing', 'permit_billing')
                    ->options(fn() => PermitBilling::active()->toCollection()->pluck('description', 'id'))
                    ->displayUsingLabels()
                    ->hideFromIndex()
                    ->nullable(),
            ]),

            Panel::make('Client Address', [
                Select::make('Mailing Prepared For', 'mailing_prepared_for')
                    ->searchable()
                    ->dependsOn(['resource:automations', 'automation'], function (Select $field, NovaRequest $request, FormData $formData) {
                        if (!empty($formData->get('automation'))) {
                            $automation = PaceAutomation::find($formData->get('automation'));
                        } else if (!empty($formData->get('resource:automations'))) {
                            $automation = PaceAutomation::find($formData->get('resource:automations'));
                        }

                        if (!empty($automation)) {
                            $options = Contact::customerActive(customer: $automation->customer)
                                ->toCollection()
                                ->filter(fn (Contact $item) => !empty($item->lastName))
                                ->transform(function (Contact $item) {
                                    return [
                                        'id' => $item->id,
                                        'name' => "{$item->firstName} {$item->lastName} {$item->address1} {$item->city} {$item->state} {$item->zip}"
                                    ];
                                });
                            $field->options($options->pluck('name', 'id'));
                        }
                    })
                    ->displayUsingLabels()
                    ->hideFromIndex()
                    ->nullable(),
            ])->withToolbar(),

            Panel::make('Addressing of Piece', [
                Select::make('Permit Print', 'permit_print')
                    ->options(fn() => PermitPrint::active()->toCollection()->pluck('description', 'id'))
                    ->displayUsingLabels()
                    ->hideFromIndex()
                    ->nullable(),
                Select::make('Return Print', 'return_print')
                    ->options(fn() => ReturnPrint::active()->toCollection()->pluck('description', 'id'))
                    ->displayUsingLabels()
                    ->hideFromIndex()
                    ->nullable(),
                Select::make('Print Type', 'print_type')
                    ->options(fn() => PrintType::active()->toCollection()->pluck('description', 'id'))
                    ->displayUsingLabels()
                    ->hideFromIndex()
                    ->nullable(),
                Select::make('Print Case', 'print_case')
                    ->options(fn() => PrintCase::active()->toCollection()->pluck('description', 'id'))
                    ->displayUsingLabels()
                    ->hideFromIndex()
                    ->nullable(),
                Select::make('Extra Stock', 'extra_stock')
                    ->options(fn() => ExtraStock::active()->toCollection()->pluck('description', 'id'))
                    ->displayUsingLabels()
                    ->hideFromIndex()
                    ->nullable(),
                Select::make('Address Format', 'address_format')
                    ->options(fn() => AddressFormat::active()->toCollection()->pluck('description', 'id'))
                    ->displayUsingLabels()
                    ->hideFromIndex()
                    ->nullable(),
                Text::make('Instructions', 'instructions')
                    ->hideFromIndex()
                    ->nullable(),
                Text::make('Return Address', 'return_address')
                    ->hideFromIndex()
                    ->nullable(),
            ])->withToolbar(),
        ];
    }

    public function cards(NovaRequest $request)
    {
        return [];
    }

    public function filters(NovaRequest $request)
    {
        return [];
    }

    public function lenses(NovaRequest $request)
    {
        return [];
    }

    public function actions(NovaRequest $request)
    {
        return [];
    }
}
