<?php

namespace Ptb\Pace\Castables;

use Illuminate\Support\Collection;
use Spatie\LaravelData\Casts\Cast;
use Spatie\LaravelData\Casts\Castable;
use Spatie\LaravelData\Support\DataProperty;

class ToCollection implements Castable
{
    public static function dataCastUsing(...$arguments): Cast
    {
        return new class implements Cast {
            public function cast(DataProperty $property, mixed $value, array $context): Collection
            {
                if (!is_iterable($value)) {
                    return collect([
                        $value
                    ]);
                }

                return collect($value);
            }
        };
    }
}