<?php

namespace Ptb\Pace\Requests;

use Ptb\Pace\Data\Estimate;
use Ptb\Pace\Data\EstimateInfo;
use Ptb\Pace\PaceConnector;

final class CreateEstimateRequest
{
    /**
     * @param EstimateInfo $estimateInfo
     * @return Estimate
     */
    public function handle(EstimateInfo $estimateInfo): Estimate
    {
        $estimate = @app(PaceConnector::class)
            ->service('InvokeAction')
            ->createEstimate(estimateInfo: $estimateInfo);

        return Estimate::from($estimate);
    }
}