<?php

namespace Ptb\Pace\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Database\Eloquent\SoftDeletes;
use Ptb\Pace\Data\JobProductType;

class PaceAutomation extends Model
{
    use SoftDeletes;

    protected $guarded = [];
    protected $casts = [
        'customer' => 'string',
        'product_type_id' => 'string',
        'content_file_category' => 'integer',
        'each_of' => 'integer',
        'ink_coverage_front' => 'integer',
        'ink_coverage_back' => 'integer',
        'virtual_printer_id' => 'integer',
        'ship_via' => 'integer',
        'job_lead_time' => 'integer',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
        'deleted_at' => 'datetime',
    ];

    /**
     * @return mixed
     */
    public function getJobProductTypeAttribute(): JobProductType
    {
        return JobProductType::from($this->product_type_id);
    }

    /**
     * @return HasOne
     */
    public function mailing(): HasOne
    {
        return $this->hasOne(PaceAutomationMailing::class, 'pace_automation_id');
    }

    /**
     * @return BelongsToMany
     */
    public function tasks(): BelongsToMany
    {
        return $this->belongsToMany(PaceTask::class);
    }
}
