<?php

namespace Ptb\Pace\Transformers;

use Carbon\Carbon;
use Spatie\LaravelData\Support\DataProperty;
use Spatie\LaravelData\Transformers\Transformer;

class AsCarbon implements Transformer
{

    public function transform(DataProperty $property, mixed $value): mixed
    {
        if (empty($value)) {
            return null;
        }

        if ($value instanceof Carbon) {
            return $value;
        }

        return Carbon::parse($value);
    }
}