<?php

namespace Ptb\Pace\Castables;

use Carbon\Carbon;
use Spatie\LaravelData\Casts\Cast;
use Spatie\LaravelData\Casts\Castable;
use Spatie\LaravelData\Support\DataProperty;

class ToCarbon implements Castable
{
    public static function dataCastUsing(...$arguments): Cast
    {
        return new class implements Cast {
            public function cast(DataProperty $property, mixed $value, array $context): ?Carbon
            {
                // if empty string or null don't try to parse it
                if (empty($value)) {
                    return null;
                }

                if ($value instanceof Carbon) {
                    return $value;
                }

                return Carbon::parse($value);
            }
        };
    }
}