<?php

namespace Ptb\Pace\Actions\Estimates;

use Ptb\Pace\Data\EstimateInfo;
use Ptb\Pace\Models\PaceTask;

final class CreateEstimateInfo
{

    /**
     * @param PaceTask $task
     * @param array $options
     * @return EstimateInfo
     */
    public function handle(PaceTask $task, array $options = []): EstimateInfo
    {
        return EstimateInfo::from([
            'reference' => $task->task_reference,
            'customer' => data_get($options, 'customer'),
            'estimateDescription' => substr($task->task_description, 0, 50),
        ]);
    }
}