<?php

namespace Ptb\Pace\Console\Commands;

use Illuminate\Console\Command;
use Ptb\Pace\Data\ActivityCode;
use Ptb\Pace\Data\AddressFormat;
use Ptb\Pace\Data\CostCenter;
use Ptb\Pace\Data\CSR;
use Ptb\Pace\Data\Customer;
use Ptb\Pace\Data\DeDupeType;
use Ptb\Pace\Data\Department;
use Ptb\Pace\Data\Distribution;
use Ptb\Pace\Data\ExtraStock;
use Ptb\Pace\Data\InsertType;
use Ptb\Pace\Data\JobStatus;
use Ptb\Pace\Data\JobType;
use Ptb\Pace\Data\ListSource;
use Ptb\Pace\Data\MailingClass;
use Ptb\Pace\Data\MailingSize;
use Ptb\Pace\Data\MailingTabs;
use Ptb\Pace\Data\MailingType;
use Ptb\Pace\Data\PermitBilling;
use Ptb\Pace\Data\PermitPrint;
use Ptb\Pace\Data\PermitUsed;
use Ptb\Pace\Data\PostageType;
use Ptb\Pace\Data\PrintCase;
use Ptb\Pace\Data\PrintType;
use Ptb\Pace\Data\ReturnPrint;
use Ptb\Pace\Data\SalesCategory;
use Ptb\Pace\Data\ShipVia;
use Ptb\Pace\Data\VirtualPrinter;

class CacheWarmupCommand extends Command
{
    protected $signature = 'ptb:pace-cache';
    protected $description = 'Warms up cache for specific PACE API resources';

    public function handle(): int
    {
        $this->components->task('ActivityCode', fn() => ActivityCode::active());
        $this->components->task('AddressFormat', fn() => AddressFormat::active());
        $this->components->task('CostCenter', fn() => CostCenter::active());
        $this->components->task('Customer', fn() => Customer::active());
        $this->components->task('CSR', fn() => CSR::active());
        $this->components->task('DeDupeType', fn() => DeDupeType::active());
        $this->components->task('Department', fn() => Department::active());
        $this->components->task('Distribution', fn() => Distribution::active());
        $this->components->task('ExtraStock', fn() => ExtraStock::active());
        $this->components->task('InsertType', fn() => InsertType::active());
        $this->components->task('JobStatus', fn() => JobStatus::active());
        $this->components->task('JobType', fn() => JobType::active());
        $this->components->task('ListSource', fn() => ListSource::active());
        $this->components->task('MailingClass', fn() => MailingClass::active());
        $this->components->task('MailingSize', fn() => MailingSize::active());
        $this->components->task('MailingTabs', fn() => MailingTabs::active());
        $this->components->task('MailingType', fn() => MailingType::active());
        $this->components->task('PermitBilling', fn() => PermitBilling::active());
        $this->components->task('PermitPrint', fn() => PermitPrint::active());
        $this->components->task('PermitUsed', fn() => PermitUsed::active());
        $this->components->task('PostageType', fn() => PostageType::active());
        $this->components->task('PrintCase', fn() => PrintCase::active());
        $this->components->task('PrintType', fn() => PrintType::active());
        $this->components->task('ReturnPrint', fn() => ReturnPrint::active());
        $this->components->task('SalesCategory', fn() => SalesCategory::active());
        $this->components->task('ShipVia', fn() => ShipVia::active());
        $this->components->task('VirtualPrinter', fn() => VirtualPrinter::active());

        return 0;
    }
}
