<?php

namespace Ptb\Pace;

use Saloon\Http\Auth\BasicAuthenticator;
use Saloon\Http\Connector;
use Saloon\Traits\Plugins\AcceptsJson;

class PaceRestConnector extends Connector
{
    use AcceptsJson;

    /**
     * The Base URL of the API
     */
    public function resolveBaseUrl(): string
    {
        return 'https://'.config('pace.host').'/rpc/rest/services';
    }

    /**
     * Default headers for every request
     */
    protected function defaultHeaders(): array
    {
        return [];
    }

    /**
     * Default HTTP client options
     */
    protected function defaultConfig(): array
    {
        return [
            'verify' => false,
        ];
    }

    /**
     * Default Authenticator
     */
    protected function defaultAuth(): BasicAuthenticator
    {
        return new BasicAuthenticator($this->username, $this->password);
    }

    /**
     * Create connector instance
     */
    public function __construct(
        private readonly string $username,
        private readonly string $password,
    ) {
        //
    }
}
