<?php

namespace Ptb\Pace\Models;

use Illuminate\Support\Collection;
use Ptb\Pace\Castables\ToCollection;
use Spatie\LaravelData\Attributes\DataCollectionOf;
use Spatie\LaravelData\Attributes\WithCastable;

class EstimateConvertToJobPart extends \Ptb\Pace\Contracts\Model
{
    public function __construct(
        public string|null           $description,
        public EstimatePart|null     $estimatePart,
        public int|null              $partNumber,
        #[WithCastable(ToCollection::class)]
        #[DataCollectionOf(EstimateQuantity::class)]
        public Collection|null       $quantities,
        public EstimateQuantity|null $quantityToConvert,
        public bool|null             $selected,
        public float|null            $sequence,
    )
    {
        //
    }

}
