<?php

namespace Ptb\Pace\Models;

use Carbon\Carbon;
use Ptb\Pace\Castables\ToCarbon;
use Ptb\Pace\Transformers\AsCarbon;
use Spatie\LaravelData\Attributes\WithCastable;
use Spatie\LaravelData\Attributes\WithTransformer;


class ActivityCode extends \Ptb\Pace\Contracts\Model
{
    

    public function __construct(
        public bool|null   $active,
        public mixed       $id,
        public bool|null   $addJobTracking,
        public string|null $askCounts,
        public bool|null   $askIfComplete,
        public bool|null   $askInventory,
        public string|null $askNonPlannedReason,
        public string|null $askNotes,
        public bool|null   $askNotesByLine,
        public string|null $askQuantityOfMaterials,
        public mixed       $changeJobStatusTo,
        public int|null    $chargeBasis,
        public mixed       $cogsCredit,
        public mixed       $cogsDebit,
        public int|null    $comboJobPercentageCalculationRoundingMethod,
        public int|null    $comboJobPercentageCalculationType,
        public int|null    $comboJobPercentageCalculationXpath,
        public bool|null   $consolidateExtras,
        public mixed       $costCenter,
        public mixed       $costMarkupCategory,
        public bool|null   $createActualCosts,
        public string|null $defaultCompleteValue,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $leadTime,
        public string|null $description,
        public mixed       $estimateActivityCode,
        public int|null    $estimateResultType,
        public bool|null   $excludeProdUnitsInRollup,
        public bool|null   $gangedDCActivityMaterialPullConsolodation,
        public int|null    $gangedJobCostDistributionMethod,
        public mixed       $generalOACategory,
        public mixed       $glDepartment,
        public float|null  $hrsPerProdUnit,
        public bool|null   $includeAsCost,
        public bool|null   $includeInValueAdded,
        public bool|null   $includeNonInventoryItems,
        public string|null $ioID,
        public mixed       $inventoryItem,
        public string|null $inventoryPrompt,
        public mixed       $invoiceExtraType,
        public string|null $jdfDefaultPhase,
        public int|null    $jobPlanLevel,
        public mixed       $laborCostCategory,
        public mixed       $laborOverheadCategory,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $lagTime,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $lastModified,
        public mixed       $linkStatus,
        public mixed       $machineCostCategory,
        public mixed       $markupCategory,
        public mixed       $materialActivityCode,
        public mixed       $materialOtherCategory,
        public float|null  $matlAmtPerUnit,
        public string|null $matilPrompt,
        public int|null    $matlQtyPerUnit,
        public int|null    $maxQuantity,
        public bool|null   $multipleUpstreamTasks,
        public mixed       $normalPayRate,
        public bool|null   $onCriticalDateDashboard,
        public bool|null   $outsidePurchase,
        public bool|null   $paper,
        public bool|null   $planByPass,
        public int|null    $panningIntegration,
        public int|null    $planningTimeCalculation,
        public float|null  $planningTimeCalculationPercent,
        public int|null    $planManagerDMICategory,
        public int|null    $plantManagerId,
        public int|null    $plantManagerReportCategory,
        public mixed       $postageActivityCode,
        public int|null    $prePressAct,
        public mixed       $predecessor,
        public string|null $productionUnitsDes,
        public bool|null   $revenueProducing,
        public mixed       $rollupActivity,
        public mixed       $salesCategory,
        public bool|null   $showJobPlanOnTaskList,
        public bool|null   $showMaterialsOnTaskList,
        public mixed       $sourceOrganizationCompany,
        public float|null  $standProdUnitsPerH,
        public float|null  $standardCharge,
        public array|null  $tags,
        public int|null    $templateLine,
        public float|null  $timeUntilLate,
        public mixed       $uom,
        public bool|null   $updateCurDept,
        public bool|null   $updateJobPartLocation,
        public bool|null   $updatePlanning,
        public bool|null   $useComboSplit,
        public mixed       $wipCategory,
        public mixed       $wipCredit,
        public mixed       $wipDebit,
    )
    {
        //
    }

}
