<?php

namespace Ptb\Pace\Requests\FindObjects;


use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

class FindAndSortObjects extends Request implements HasBody
{
    use HasJsonBody;

    /**
     * The HTTP method of the request
     */
    protected Method $method = Method::POST;

    /**
     * The endpoint for the request
     */
    public function resolveEndpoint(): string
    {
        return '/FindObjects/findAndSort';
    }

    protected function defaultQuery(): array
    {
        return [
            'type' => $this->type,
            'xpath' => $this->xpath,
        ];
    }

    public function defaultBody(): array
    {
        return $this->xpathSorts;
    }

    public function __construct(
        private readonly string $type,
        private readonly string $xpath,
        private readonly ?array $xpathSorts = [],
    )
    {}
}
