<?php

namespace Ptb\Pace\Models;

use Carbon\Carbon;
use Ptb\Pace\Castables\ToCarbon;
use Ptb\Pace\Query\Queryable;
use Ptb\Pace\Transformers\AsCarbon;
use Spatie\LaravelData\Attributes\WithCastable;
use Spatie\LaravelData\Attributes\WithTransformer;


class JobStatus extends \Ptb\Pace\Contracts\Model
{
    

    public function __construct(
        public bool|null   $active,
        public bool|null   $admin,
        public bool|null   $adminToProduction,
        public string|null $askComments,
        public string|null $askReason,
        public bool|null   $autoChangable,
        public bool|null   $autoCountOK,
        public bool|null   $billingOK,
        public string|null $description,
        public bool|null   $dsfCancelled,
        public bool|null   $dsfCompleted,
        public mixed       $dsfOrderStatus,
        public bool|null   $editable,
        public string|null $externalStatus,
        public string|null $fieryCentralState,
        public mixed       $id,
        public bool|null   $imposeOK,
        public string|null $inProduction,
        public bool|null   $inTransit,
        public string|null $ioID,
        public bool|null   $jobChargedOK,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $lastModified,
        public bool|null   $okToFCMakeReadyExport,
        public bool|null   $openJob,
        public bool|null   $pageflexComplete,
        public bool|null   $postActualCostsFromEstimate,
        public bool|null   $printableCancelled,
        public bool|null   $production,
        public bool|null   $readyForDeviceSubmission,
        public bool|null   $schedOK,
        public mixed       $sourceOrganizationCompany,
        public mixed       $statusType,
        public array|null  $tags,
        public int|null    $templateLine,
        public bool|null   $updateJobVersion,
    )
    {
        //
    }

}
