<?php

namespace Ptb\Pace\Requests;

use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

class CloneObject extends Request implements HasBody
{
    use HasJsonBody;

    /**
     * The HTTP method of the request
     */
    protected Method $method = Method::POST;

    /**
     * The endpoint for the request
     */
    public function resolveEndpoint(): string
    {
        return "/CloneObject/clone{$this->type}";
    }

    public function __construct(
        private readonly string $type,
        private readonly array $queryParams,
        private readonly array $payload,
    )
    {
        foreach ($this->queryParams as $key => $value) {
            $this->query()->add($key, $value);
        }


        $this->body()->set($this->payload);
    }
}
