<?php

namespace Ptb\Pace\Models;

use Carbon\Carbon;
use Ptb\Pace\Castables\ToCarbon;
use Ptb\Pace\Contracts\Model;
use Ptb\Pace\Transformers\AsCarbon;
use Spatie\LaravelData\Attributes\WithCastable;
use Spatie\LaravelData\Attributes\WithTransformer;


class ItemTemplate extends Model
{
    public function __construct(
        public ?bool $active,
        public ?string $altDescription,
        public ?bool $autoRecalculate,
        public ?string $baseObject,
        public ?string $code,
        public ?bool $comboTemplate,
        public ?bool $createQuote,
        public ?string $customer,
        public ?string $description,
        public ?int $estimate,
        public ?int $estimatePart,
        public ?int $estimateVersion,
        public ?string $ioID,
        public ?string $itemTemplateType,
        public ?string $jobDescription,
        public ?string $jobProductType,
        public ?bool $legacyMode,
        public ?string $note,
        public ?string $qtyOptions,
        public ?string $quantityExpression,
        public ?int $quote,
        public ?int $quoteProduct,
        public ?int $salesCategory,
        public ?string $setupBy,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public ?Carbon $setupDate,
        public ?string $sourceOrganizationCompany,
        public ?array $tags,
        public ?int $templateLine,
        public ?float $unitWeight,
    )
    {
        //
    }

}
