<?php

namespace Ptb\Pace\Models;

use Carbon\Carbon;
use Ptb\Pace\Castables\ToCarbon;
use Ptb\Pace\Query\Queryable;
use Ptb\Pace\Transformers\AsCarbon;
use Spatie\LaravelData\Attributes\WithCastable;
use Spatie\LaravelData\Attributes\WithTransformer;

class CSR extends \Ptb\Pace\Contracts\Model
{
    

    public function __construct(
        public bool|null   $active,
        public string|null $email,
        public mixed       $id,
        public string|null $ioID,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $lastModified,
        public string|null $name,
        public string|null $password,
        public string|null $phoneExtension,
        public string|null $phoneNumber,
        public mixed       $sourceOrganizationCompany,
        public array|null  $tags,
        public int|null    $templateLine,
    )
    {
        //
    }
}
