<?php

namespace Ptb\Pace\Requests;

use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

class UpdateObject extends Request implements HasBody
{
    use HasJsonBody;

    /**
     * The HTTP method of the request
     */
    protected Method $method = Method::POST;

    /**
     * The endpoint for the request
     */
    public function resolveEndpoint(): string
    {
        return "/UpdateObject/update{$this->type}";
    }

    /**
     * @param string $type
     * @param array $data
     */
    public function __construct(
        private readonly string $type,
        private readonly array $data,
    )
    {
        $this->body()->set($this->data);
    }
}
