<?php

namespace Ptb\Pace\Models;

use Carbon\Carbon;
use Ptb\Pace\Castables\ToCarbon;
use Ptb\Pace\Query\Queryable;
use Ptb\Pace\Transformers\AsCarbon;
use Spatie\LaravelData\Attributes\WithCastable;
use Spatie\LaravelData\Attributes\WithTransformer;

class CartonContent extends \Ptb\Pace\Contracts\Model
{
    

    public function __construct(
        public mixed       $billedContent,
        public mixed       $carton,
        public string|null $content,
        public string|null $contentDescription,
        public string|null $contentQuantityOrdered,
        public mixed       $id,
        public string|null $ioID,
        public mixed       $job,
        public mixed       $jobComponent,
        public mixed       $jobMaterial,
        public string|null $jobPart,
        public mixed       $JobPartKey,
        public mixed       $jobPartPressForm,
        public mixed       $jobProduct,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $lastModified,
        public string|null $note,
        public int|null    $originalPlannedQuantity,
        public string|null $productID,
        public mixed       $proof,
        public int|null    $quantity,
        public int|null    $quantityInvoiced,
        public int|null    $quantityToBeInvoiced,
        public int|null    $sequence,
        public mixed       $sourceOrganizationCompany,
        public array|null  $tags,
        public int|null    $templateLine,
        public int|null    $totalQuantity,
    )
    {
        //
    }

}
