<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('pace_automation_mailings', function (Blueprint $table) {
            $table->id();
            $table->foreignId('pace_automation_id')->constrained('pace_automations')->cascadeOnDelete();
            $table->integer('address_format')->nullable();
            $table->boolean('aspect_ratio')->nullable();
            $table->boolean('barcode')->nullable();
            $table->boolean('cass_list')->nullable();
            $table->boolean('clean_list')->nullable();
            $table->boolean('co_mingle')->nullable();
            $table->integer('distribution')->nullable();
            $table->boolean('duplicate_address')->nullable();
            $table->integer('extra_stock')->nullable();
            $table->integer('de_dupe_type')->nullable();
            $table->integer('insert_type')->nullable();
            $table->string('instructions')->nullable();
            $table->integer('list_source')->nullable();
            $table->integer('mailing_class')->nullable();
            $table->integer('mailing_prepared_for')->nullable();
            $table->integer('mailing_size')->nullable();
            $table->integer('mailing_tabs')->nullable();
            $table->integer('mailing_type')->nullable();
            $table->boolean('matched_mailing')->nullable();
            $table->boolean('ncoa_list')->nullable();
            $table->integer('permit_billing')->nullable();
            $table->integer('permit_print')->nullable();
            $table->integer('permit_used')->nullable();
            $table->integer('postage_type')->nullable();
            $table->integer('print_case')->nullable();
            $table->integer('print_type')->nullable();
            $table->boolean('remove_duplicate_address')->nullable();
            $table->boolean('remove_international')->nullable();
            $table->boolean('remove_undeliverable')->nullable();
            $table->string('return_address')->nullable();
            $table->integer('return_print')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('pace_automation_mailings');
    }
};
