<?php

namespace Ptb\Pace\Models;

use Carbon\Carbon;
use Ptb\Pace\Castables\ToCarbon;
use Ptb\Pace\Query\Queryable;
use Ptb\Pace\Transformers\AsCarbon;
use Spatie\LaravelData\Attributes\WithCastable;
use Spatie\LaravelData\Attributes\WithTransformer;


class GlAccountingPeriod extends \Ptb\Pace\Contracts\Model
{
    

    public function __construct(
        public int|null    $accountingPeriod,
        public bool|null   $closingPeriod,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $endDate,
        public int|null    $fiscalYear,
        public string|null $glPeriodStatus,
        public mixed       $id,
        public string|null $ioID,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $lastModified,
        public int|null    $month,
        public string|null $periodString,
        public string|null $periodTitle,
        public mixed       $sourceOrganizationCompany,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $startDate,
        public array|null  $tags,
        public int|null    $templateLine,
    )
    {
        //
    }

}
