<?php

namespace Ptb\Pace\Requests\InvokeAction;

use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

class CalculateEstimate extends Request implements HasBody
{
    use HasJsonBody;

    /**
     * The HTTP method of the request
     */
    protected Method $method = Method::POST;

    /**
     * The endpoint for the request
     */
    public function resolveEndpoint(): string
    {
        return "/InvokeAction/calculateEstimate";
    }

    /**
     * @param mixed $estimatePrimaryKey
     */
    public function __construct(
        private readonly mixed $estimatePrimaryKey
    )
    {
        $this->query()->add('estimatePrimaryKey', $this->estimatePrimaryKey);
    }

}
