<?php

namespace Ptb\Pace;

use Illuminate\Support\ServiceProvider;

class PaceServiceProvider extends ServiceProvider
{

    /**
     * Register any application services
     *
     * @return void
     */
    public function register(): void
    {
        $this->app->singleton(
            abstract: PaceRestConnector::class,
            concrete: function ($app) {
                $config = $app['config']['pace'];

                return new PaceRestConnector(
                    username: $config['login'],
                    password: $config['password'],
                );
            }
        );
    }

    /**
     * Bootstrap any application services
     *
     * @return void
     */
    public function boot(): void
    {

        $this->mergeConfigFrom(
            path: __DIR__ . '/../config/pace.php',
            key: 'pace'
        );

    }

    /**
     * Get the services provided by the provider
     *
     * @return string[]
     */
    public function provides(): array
    {
        return [

        ];
    }
}
