<?php

namespace Ptb\Pace\Requests\TransactionService;

use Saloon\Enums\Method;
use Saloon\Http\Request;

class Rollback extends Request
{
    /**
     * The HTTP method of the request
     */
    protected Method $method = Method::GET;

    /**
     * The endpoint for the request
     */
    public function resolveEndpoint(): string
    {
        return "/TransactionService/rollback";
    }

        /**
     * @return array
     */
    protected function defaultQuery(): array
    {
        return array_filter([
            'txnId' => $this->txnId,
        ]);
    }

    public function __construct(
        private readonly ?string $txnId = null,
    )
    {
        //
    }
}
