<?php

namespace Ptb\Pace\Requests\AttachmentService;

use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Storage;
use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

class AddAttachment extends Request implements HasBody
{
    use HasJsonBody;

    /**
     * The HTTP method of the request
     */
    protected Method $method = Method::POST;

    /**
     * The endpoint for the request
     */
    public function resolveEndpoint(): string
    {
        return "/AttachmentService/addAttachment";
    }

    public function __construct(
        private readonly string $type,
        private readonly string $primaryKey,
        private readonly string $attribute,
        private readonly string $path,
    ) {
        $this->query()->add('type', $this->type);
        $this->query()->add('pKey', $this->primaryKey);
        $this->query()->add('attribute', $this->attribute);

        $this->body()->set([
            'name' => basename($this->path),
            'content' => base64_encode(Storage::get($this->path)),
            'mimeType' => Storage::mimeType($this->path),
            'fileExtension' => pathinfo($this->path, PATHINFO_EXTENSION),
        ]);
    }
}
