<?php

namespace Ptb\Pace\Models;

use Carbon\Carbon;
use Ptb\Pace\Castables\ToCarbon;
use Ptb\Pace\Transformers\AsCarbon;
use Spatie\LaravelData\Attributes\WithCastable;
use Spatie\LaravelData\Attributes\WithTransformer;


class Job extends \Ptb\Pace\Contracts\Model
{

    public function __construct(
        public bool|null $addPlanFromJobType,
        public string|null $adminStatus,
        public float|null $allowableOvers,
        public string|null $altCurrency,
        public float|null $altCurrencyRate,
        public string|null $altCurrencyRateSource,
        public string|null $altCurrencyRateSourceNote,
        public float|null $amountInvoiced,
        public float|null $amountToInvoice,
        public bool|null $amountToInvoiceForced,
        public mixed $attachment,
        public bool|null $billPartOneOnlyAttribute,
        public bool|null $billPartsTogether,
        public bool|null $billPartsTogetherAttribute,
        public int|null $billToJobContact,
        public float|null $billedAmt,
        public int|null $certificationAuthority,
        public int|null $certificationLevel,
        public float|null $changeOrderTotal,
        public string|null $chargeBackAccount,
        public bool|null $comboDirty,
        public string|null $comboJobPercentageCalculationType,
        public string|null $comboJobValidationWarning,
        public float|null $comboTotal,
        public string|null $contactFirstName,
        public string|null $contactLastName,
        public bool|null $convertingToJob,
        public int|null $createdByConnect,
        public int|null $createdFromAnsix12850,
        public string|null $crmId,
        public int|null $csr,
        public string|null $currentStatus,
        public string|null $customer,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $dateTimeSetup,
        public int|null $defaultPartQuantity,
        public int|null $defaultProduct,
        public float|null $depositAmount,
        public string|null $description,
        public string|null $description2,
        public bool|null $destinationBasedTaxing,
        public bool|null $dsfCreditCardFinalized,
        public int|null $dsfOrderID,
        public string|null $dsfPaymentMethod,
        public string|null $earliestProofDue,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $earliestProofDueDate,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $earliestProofDueTime,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $earliestProofShipDate,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $earliestProofShipDateTime,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $earliestProofShipTime,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $earliestStartDateTime,
        public string|null $enteredBy,
        public bool|null $epaceEstimate,
        public bool|null $executeSync,
        public bool|null $finishingScheduled,
        public int|null $finishingScheduledFlag,
        public string|null $freeFormAccountNumber,
        public float|null $freightAmountTotal,
        public string|null $freightOnBoard,
        public bool|null $ignoreItemTemplateFinalizePrintFlow,
        public string|null $importID,
        public string|null $invoiceLevelOptions,
        public string|null $invoiceUOM,
        public bool|null $invoiceUOMForced,
        public bool|null $invoiceW2PHandlingAmount,
        public bool|null $invoiceW2POrderAmount,
        public bool|null $invoiceW2PShippingAmount,
        public bool|null $invoiceW2PTaxAmount,
        public string|null $ioID,
        public string|null $isbn,
        public string|null $itemTemplate,
        public bool|null $itemizedInvoicing,
        public string|null $iwayOrderID,
        public string|null $iwayUserId,
        public string|null $jdeDocumentType,
        public string|null $jdfSubmittedQueueEntryError,
        public bool|null $jdfSubmitted,
        public string|null $job,
        public int|null $jobContact,
        public int|null $jobJacketVersion,
        public string|null $jobOrderType,
        public string|null $jobProductType,
        public string|null $jobProject,
        public int|null $jobType,
        public float|null $jobValue,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $lastStatusChangedDateTime,
        public int|null $legalEntity,
        public int|null $manufacturingLocation,
        public string|null $metrixID,
        public string|null $metrixPrepressJDF,
        public string|null $metrixPrepressStrippingJDF,
        public string|null $mxml,
        public string|null $newJDFID,
        public string|null $noteToAdd,
        public string|null $numberNote,
        public int|null $numberPositions,
        public string|null $numberPrefix,
        public bool|null $numberGuaranteed,
        public int|null $opportunity,
        public float|null $originalQuotedPrice,
        public bool|null $originalQuotedPriceForced,
        public string|null $oversMethod,
        public string|null $pageflexOrderID,
        public string|null $parentJob,
        public string|null $part1JobProductType,
        public int|null $part1NumSigs,
        public int|null $part1QuantityOrdered,
        public float|null $part1QuotedPrice,
        public float|null $paymentAuthorizationAmount,
        public string|null $paymentAuthorizationBillingName,
        public string|null $paymentAuthorizationCardExpiration,
        public string|null $paymentAuthorizationCardType,
        public string|null $paymentAuthorizationCardholderAddress1,
        public string|null $paymentAuthorizationCardholderCity,
        public string|null $paymentAuthorizationCardholderState,
        public string|null $paymentAuthorizationCardholderZip,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $paymentAuthorizationDate,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $paymentAuthorizationTime,
        public string|null $paymentAuthorizationToken,
        public string|null $paymentProfileToken,
        public float|null $pendingBilledAmt,
        public int|null $plantManagerId,
        public string|null $pnref,
        public string|null $poNum,
        public bool|null $prePressScheduled,
        public int|null $prePressScheduledFlag,
        public string|null $prevAdminStatus,
        public string|null $prevStatusComment,
        public int|null $prevStatusReason,
        public string|null $prevStatusReasonReason,
        public int|null $priceList,
        public int|null $printStreamOrderID,
        public string|null $printStreamPaymentMethod,
        public string|null $printableOrderID,
        public string|null $printableSwoID,
        public int|null $priority,
        public int|null $productOrder,
        public string|null $profileToken,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $promiseDateTime,
        public bool|null $promptForMultipleParts,
        public bool|null $promptForMultipleProducts,
        public int|null $qtyBilled,
        public int|null $qtyOrdered,
        public int|null $qtyShipped,
        public int|null $quantityOrdered,
        public bool|null $quantityOrderedForced,
        public float|null $quantityRemaining,
        public string|null $queueEntryID,
        public string|null $quoteNumber,
        public bool|null $readyToSchedule,
        public string|null $reference,
        public string|null $reprintType,
        public string|null $routingIdentifier,
        public int|null $routingTemplate,
        public int|null $salesCategory,
        public bool|null $salesCategoryForced,
        public int|null $salesPerson,
        public int|null $salutation,
        public bool|null $scheduled,
        public int|null $scheduledFlag,
        public bool|null $scheduledShipDateForced,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $scheduledDateTime,
        public bool|null $scheduledShipTimeForced,
        public string|null $shipInNameOf,
        public int|null $shipToJobContact,
        public int|null $shipVia,
        public int|null $shoppingCart,
        public string|null $sourceOrganizationCompany,
        public int|null $startNumber,
        public string|null $state,
        public string|null $statusComment,
        public int|null $statusReason,
        public string|null $statusReasonComments,
        public int|null $subJobType,
        public bool|null $suppressEmail,
        public array|null $tags,
        public int|null $taxCategory,
        public bool|null $taxCategoryForced,
        public int|null $templateLine,
        public int|null $terms,
        public int|null $totalOrderLines,
        public int|null $totalParts,
        public float|null $totalPriceAllParts,
        public bool|null $useLegacyPrintFlotFormatFinishing,
        public bool|null $useLegacyPrintFlowFormatPrePress,
        public int|null $userInterfaceSet,
        public float|null $w2pHandlingAmount,
        public float|null $wspShippingAmount,
        public float|null $w2pTaxAmount,
        public string|null $webID,
        public string|null $webOrderID,
    )
    {
        //
    }

}
