<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('pace_task_parts', function (Blueprint $table) {
            $table->id();
            $table->foreignId('pace_task_id')->constrained('pace_tasks')->cascadeOnDelete();
            $table->foreignId('pace_automation_id')->constrained('pace_automations')->cascadeOnUpdate();
            $table->string('part_description');
            $table->integer('part_qty')->default(0);
            $table->string('part_job_part')->nullable();
            $table->string('part_status')->default('pending');
            $table->string('part_content_file_location')->nullable();
            $table->string('part_mail_reports_location')->nullable();
            $table->decimal('part_postage_amount', 12, 3)->default(0);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('pace_task_parts');
    }
};
