<?php

namespace Ptb\Pace\Requests\AttachmentService;

use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

class GetAttachmentFromKey extends Request
{
    /**
     * The HTTP method of the request
     */
    protected Method $method = Method::GET;

    /**
     * The endpoint for the request
     */
    public function resolveEndpoint(): string
    {
        return "/AttachmentService/getAttachmentFromKey";
    }

    /**
     * @return array
     */
    protected function defaultQuery(): array
    {
        return [
            'attachmentKey' => $this->attachmentKey,
        ];
    }

    public function __construct(
        private readonly string $attachmentKey,
    ) {
        //
    }
}
