<?php

namespace Ptb\Pace\Requests\AttachmentService;

use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

class AddAttachment extends Request implements HasBody
{
    use HasJsonBody;

    /**
     * The HTTP method of the request
     */
    protected Method $method = Method::POST;

    /**
     * The endpoint for the request
     */
    public function resolveEndpoint(): string
    {
        return "/AttachmentServices/addAttachment";
    }

    /**
     * @return array
     */
    protected function defaultQuery(): array
    {
        return [
            'type' => $this->type,
            'pKey' => $this->primaryKey,
            'attribute' => $this->attribute,
        ];
    }

    public function __construct(
        private readonly string $type,
        private readonly string $primaryKey,
        private readonly string $attribute,
        private readonly string $attachment,
    ) {
        $this->body()->set($attachment);
    }
}
