<?php

namespace Ptb\Pace\Concerns;

use JsonException;
use Ptb\Pace\PaceRestConnector;
use Ptb\Pace\Query\Builder;
use Ptb\Pace\Requests\CreateObject;
use Ptb\Pace\Requests\UpdateObject;
use Saloon\Exceptions\Request\FatalRequestException;
use Saloon\Exceptions\Request\RequestException;
use Throwable;

trait HasApiOperations
{
    protected static PaceRestConnector $restConnector;

    /**
     * @return PaceRestConnector
     */
    protected static function getRestConnector(): PaceRestConnector
    {
        if (!isset(self::$restConnector)) {
            self::$restConnector = app(PaceRestConnector::class);
        }

        return self::$restConnector;
    }

    protected static function getShortName(): string
    {
        $reflection = new \ReflectionClass(static::class);
        return $reflection->getShortName();
    }

    /**
     * @return Builder
     */
    public static function query(): Builder
    {
        return new Builder(
            objectName: static::getShortName(),
            dataClass: static::class
        );
    }

    /**
     * @param mixed $primaryKey
     * @return mixed
     * @throws FatalRequestException
     * @throws RequestException
     * @throws Throwable
     */
    public static function find(mixed $primaryKey): static
    {
        return match (gettype($primaryKey)) {
            'string' => self::fromString($primaryKey),
            'integer' => self::fromString( (string) $primaryKey),
        };
    }

    /**
     * @param array $attributes
     * @return mixed
     * @throws FatalRequestException
     * @throws JsonException
     * @throws RequestException
     * @throws Throwable
     */
    public static function create(array $attributes = []): mixed
    {
        $response = static::getRestConnector()->send(
            request: new CreateObject(
                type: static::getShortName(),
                data: $attributes,
            )
        );

        if ($response->failed()) {
            $response->throw();
        }

        return static::from($response->json());
    }

    /**
     * @param array $attributes
     * @return mixed
     * @throws FatalRequestException
     * @throws JsonException
     * @throws RequestException
     * @throws Throwable
     */
    public static function update(array $attributes = []): mixed
    {
        if (! array_key_exists('id', $attributes)) {
            throw new \RuntimeException('Missing id attribute');
        }

        $response = static::getRestConnector()->send(
            request: new UpdateObject(
                type: static::getShortName(),
                data: $attributes,
            )
        );

        if ($response->failed()) {
            $response->throw();
        }

        return static::from($response->json());
    }

    public static function delete(mixed $primaryKey): mixed
    {

    }
}