<?php

namespace Ptb\Pace\Models;

use Carbon\Carbon;
use Ptb\Pace\Castables\ToCarbon;
use Ptb\Pace\Query\Queryable;
use Ptb\Pace\Transformers\AsCarbon;
use Spatie\LaravelData\Attributes\WithCastable;
use Spatie\LaravelData\Attributes\WithTransformer;

class ChangeOrder extends \Ptb\Pace\Contracts\Model
{
    

    public function __construct(
        public string|null $authorizedBy,
        public bool|null   $billed,
        public mixed       $component,
        public mixed       $department,
        public string|null $description,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $dueDate,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $dueTime,
        public string|null $enteredBy,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $entryDate,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $entryTime,
        public string|null $externalID,
        public mixed       $id,
        public string|null $ioID,
        public mixed       $invoice,
        public mixed       $job,
        public string|null $jobOrderID,
        public string|null $jobPart,
        public mixed       $JobPartKey,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $lastModified,
        public mixed       $nonPlannedReason,
        public string|null $notes,
        public mixed       $num,
        public string|null $orderItemID,
        public string|null $poNum,
        public string|null $referenceID,
        public string|null $revisionNum,
        public mixed       $sourceOrganizationCompany,
        public array|null  $tags,
        public float|null  $taxAmount,
        public float|null  $taxBase,
        public int|null    $templateLine,
        public float|null  $totalBillAmount,
        public float|null  $totalNCAmt,
        public mixed       $type,
    )
    {
        //
    }

}
