<?php

namespace Ptb\Pace\Requests\FindObjects;


use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

class FindSortAndLimitObjects extends Request implements HasBody
{
    use HasJsonBody;

    /**
     * The HTTP method of the request
     */
    protected Method $method = Method::POST;

    /**
     * The endpoint for the request
     */
    public function resolveEndpoint(): string
    {
        return '/FindObjects/findSortAndLimit';
    }

    /**
     * @return array
     */
    protected function defaultQuery(): array
    {
        return [
            'type' => $this->type,
            'xpath' => $this->xpath,
            'offset' => $this->offset,
            'limit' => $this->limit,
        ];
    }

    /**
     * @return array
     */
    public function defaultBody(): array
    {
        return $this->xpathSorts;
    }

    /**
     * @param string $type
     * @param string $xpath
     * @param int $offset
     * @param int $limit
     * @param array|null $xpathSorts
     */
    public function __construct(
        private readonly string $type,
        private readonly string $xpath,
        private readonly int $offset,
        private readonly int $limit,
        private readonly ?array $xpathSorts = [],
    )
    {}
}
