<?php

namespace Ptb\Pace\Requests;

use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

class DeleteObject extends Request
{
    /**
     * The HTTP method of the request
     */
    protected Method $method = Method::DELETE;

    /**
     * The endpoint for the request
     */
    public function resolveEndpoint(): string
    {
        return "/DeleteObject/DeleteObject";
    }

    /**
     * @param string $type
     * @param string $primaryKey
     */
    public function __construct(
        private readonly string $type,
        private readonly string $primaryKey
    )
    {
        $this->query()->add('type', $this->type);
        $this->query()->add('key', $this->primaryKey);
    }
}
