<?php

namespace Ptb\Pace\Requests;

use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

class ReadObject extends Request implements HasBody
{
    use HasJsonBody;

    /**
     * The HTTP method of the request
     */
    protected Method $method = Method::POST;

    /**
     * The endpoint for the request
     */
    public function resolveEndpoint(): string
    {
        return "/ReadObject/read{$this->type}";
    }

    /**
     * @param string $type
     * @param string $primaryKey
     */
    public function __construct(
        private readonly string $type,
        private readonly string $primaryKey
    )
    {
        $this->query()->add('primaryKey', $this->primaryKey);
    }
}
