<?php

namespace Ptb\Pace\Requests\AttachmentService;

use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

class GetAttachment extends Request
{

    /**
     * The HTTP method of the request
     */
    protected Method $method = Method::GET;

    /**
     * The endpoint for the request
     */
    public function resolveEndpoint(): string
    {
        return "/AttachmentService/getAttachment";
    }

    /**
     * @return array
     */
    protected function defaultQuery(): array
    {
        return [
            'type' => $this->type,
            'pKey' => $this->primaryKey,
            'attribute' => $this->attribute,
        ];
    }

    public function __construct(
        private readonly string $type,
        private readonly string $primaryKey,
        private readonly string $attribute,
    ) {
        //
    }
}
