<?php

namespace Ptb\Pace\Requests\InvokeAction;

use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

class AddEstimatePart extends Request implements HasBody
{
    use HasJsonBody;

    /**
     * The HTTP method of the request
     */
    protected Method $method = Method::POST;

    /**
     * The endpoint for the request
     */
    public function resolveEndpoint(): string
    {
        return "/InvokeAction/addEstimatePart";
    }

    /**
     * @param array $estimatePartInfo
     */
    public function __construct(
        private readonly array $estimatePartInfo
    )
    {
        $this->body()->set($this->estimatePartInfo);
    }

}
