<?php

namespace Ptb\Pace\Requests\AttachmentService;

use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

class RemoveAttachmentFromKey extends Request
{
    /**
     * The HTTP method of the request
     */
    protected Method $method = Method::DELETE;

    /**
     * The endpoint for the request
     */
    public function resolveEndpoint(): string
    {
        return "/AttachmentService/removeAttachmentFromKey";
    }

    /**
     * @return array
     */
    protected function defaultQuery(): array
    {
        return [
            'attachmentKey' => $this->attachmentKey,
        ];
    }

    public function __construct(
        private readonly string $attachmentKey,
    ) {
        //
    }
}
