<?php

namespace Ptb\Pace\Models;

use Carbon\Carbon;
use Ptb\Pace\Castables\ToCarbon;
use Ptb\Pace\Query\Queryable;
use Ptb\Pace\Transformers\AsCarbon;
use Spatie\LaravelData\Attributes\WithCastable;
use Spatie\LaravelData\Attributes\WithTransformer;


class JobProductType extends \Ptb\Pace\Contracts\Model
{
    

    public function __construct(
        public bool|null   $active,
        public string|null $additionalDescription,
        public bool|null   $autoCreateJobPartContentFile,
        public bool|null   $autoSchedule,
        public bool|null   $availableEcommerce,
        public float|null  $buySizeHeight,
        public mixed       $buySizeHeightDisplayUOM,
        public float|null  $buySizeWidth,
        public mixed       $buySizeWidthDisplayUOM,
        public mixed       $certificationProductClassification,
        public mixed       $coating,
        public bool|null   $coatingDry,
        public int|null    $coatingSides,
        public int|null    $colorsSide1,
        public int|null    $colorsSide2,
        public int|null    $colorsTotal,
        public bool|null   $comboSplit,
        public float|null  $commRate,
        public mixed       $componentType,
        public mixed       $defaultItemProductCondition,
        public string|null $description,
        public mixed       $difficulty,
        public string|null $duplexMode,
        public bool|null   $eachOfPricing,
        public string|null $fileNamePattern,
        public float|null  $finalSizeHeight,
        public mixed       $finalSizeHeightDisplayUOM,
        public float|null  $finalSizeWidth,
        public mixed       $finalSizeWidthDisplayUOM,
        public mixed       $itemsBindery,
        public int|null    $foldPattern,
        public mixed       $foldPatternKey,
        public bool|null   $gangable,
        public int|null    $grainDirection,
        public int|null    $grainSpecifications,
        public int|null    $gripperColorBar,
        public mixed       $id,
        public mixed       $inkDefault,
        public int|null    $inkType,
        public string|null $ioID,
        public mixed       $inventoryItem,
        public mixed       $itemProductType,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $lastModified,
        public bool|null   $mailing,
        public mixed       $manufacturingLocations,
        public bool|null   $metrixAccessible,
        public bool|null   $metrixEnabled,
        public mixed       $networkLocation,
        public int|null    $numAcross,
        public int|null    $numAlong,
        public int|null    $numPlies,
        public int|null    $numStagger,
        public int|null    $numUp,
        public mixed       $outsidePurchaseWorkflow,
        public string|null $pageAssemblyOrder,
        public mixed       $paper,
        public mixed       $paperWeight,
        public mixed       $patternCategory,
        public mixed       $prepressWorkFlow,
        public mixed       $press,
        public mixed       $pressEventWorkflow,
        public mixed       $pressInkType,
        public mixed       $printRunMethod,
        public mixed       $productionType,
        public mixed       $routingTemplate,
        public int|null    $runMethod,
        public int|null    $runSizeGrainDirection,
        public float|null  $runSizeHeight,
        public mixed       $runSizeHeightDisplayUOM,
        public float|null  $runSizeWidth,
        public mixed       $runSizeWidthDisplayUOM,
        public mixed       $salesCategory,
        public bool|null   $secondWeb,
        public bool|null   $separateLayout,
        public mixed       $shippingWorkFlow,
        public mixed       $sourceOrganizationCompany,
        public mixed       $speedFactor,
        public int|null    $bleedsAlong,
        public mixed       $standardPaperType,
        public bool|null   $suppressZeroPricedItems,
        public array|null  $tags,
        public mixed       $taxCategory,
        public int|null    $templateLine,
        public bool|null   $usePriceListPricing,
        public mixed       $userInterfaceSet,
        public mixed       $varnish,
        public bool|null   $varnishDry,
        public int|null    $varnishSides,
        public int|null    $bleedsAcross,
    )
    {
        //
    }

}
