<?php

namespace Ptb\Pace\Contracts;

use JsonException;
use Ptb\Pace\Concerns\HasApiOperations;
use Ptb\Pace\Requests\ReadObject;
use Saloon\Exceptions\Request\FatalRequestException;
use Saloon\Exceptions\Request\RequestException;
use Saloon\Http\Response;
use Spatie\LaravelData\Data;
use Throwable;

abstract class Model extends Data
{
    use HasApiOperations;

    /**
     * @param string $primaryKey
     * @return static
     * @throws FatalRequestException
     * @throws RequestException
     * @throws Throwable
     */
    public static function fromString(string $primaryKey): static
    {
        $response = static::getRestConnector()->send(
            request: new ReadObject(
                type: static::getSHortName(),
                primaryKey: $primaryKey
            )
        );

        if ($response->failed()) {
            $response->throw();
        }

        return self::fromResponse($response);
    }

    /**
     * @param Response $response
     * @return static
     * @throws JsonException
     */
    public static function fromResponse(Response $response): static
    {
        return static::from($response->json());
    }
}