<?php

namespace Ptb\Pace\Requests\TransactionService;

use Saloon\Enums\Method;
use Saloon\Http\Request;

class StartTransaction extends Request
{
    /**
     * The HTTP method of the request
     */
    protected Method $method = Method::GET;

    /**
     * The endpoint for the request
     */
    public function resolveEndpoint(): string
    {
        return "/TransactionService/startTransaction";
    }

    /**
     * @return array
     */
    protected function defaultQuery(): array
    {
        return array_filter([
            'timeoutInMinutes' => $this->timeoutInMinutes,
        ]);
    }

    public function __construct(
        private readonly ?int $timeoutInMinutes = null,
    )
    {
        //
    }
}
