<?php

namespace Ptb\Pace\Models;

use Carbon\Carbon;
use Ptb\Pace\Castables\ToCarbon;
use Ptb\Pace\Query\Queryable;
use Ptb\Pace\Transformers\AsCarbon;
use Spatie\LaravelData\Attributes\WithCastable;
use Spatie\LaravelData\Attributes\WithTransformer;


class SalesPerson extends \Ptb\Pace\Contracts\Model
{
    use Queryable;

    public function __construct(
        public bool|null   $active,
        public float|null  $annualQuota,
        public float|null  $commissionRate,
        public string|null $email,
        public string|null $estimatePrefix,
        public mixed       $id,
        public string|null $ioID,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $lastModified,
        public string|null $name,
        public string|null $notes,
        public string|null $password,
        public string|null $phoneExtension,
        public string|null $phoneNumber,
        public string|null $quotePrefix,
        public mixed       $sourceOrganizationCompany,
        public array|null  $tags,
        public int|null    $templateLine,
    )
    {
        //
    }

}
