<?php

namespace Ptb\Pace\Models;

use Carbon\Carbon;
use Ptb\Pace\Castables\ToCarbon;
use Ptb\Pace\Query\Queryable;
use Ptb\Pace\Transformers\AsCarbon;
use Spatie\LaravelData\Attributes\WithCastable;
use Spatie\LaravelData\Attributes\WithTransformer;

class Contact extends \Ptb\Pace\Contracts\Model
{
    use Queryable;

    public function __construct(
        public bool|null   $active,
        public string|null $address1,
        public string|null $address2,
        public string|null $address3,
        public string|null $altAddress1,
        public string|null $altAddress2,
        public string|null $altAddress3,
        public bool|null   $altAutoUpdate,
        public bool|null   $altBill,
        public string|null $altCity,
        public mixed       $altCountry,
        public mixed       $altSalutation,
        public string|null $altState,
        public mixed       $altStateKey,
        public string|null $altZip,
        public string|null $email2,
        public string|null $email3,
        public string|null $email4,
        public string|null $emailLabel2,
        public string|null $emailLabel3,
        public string|null $emailLabel4,
        public string|null $assistant,
        public string|null $assistantPhone,
        public bool|null   $autoUpdate,
        public bool|null   $billTo,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $birthDate,
        public string|null $businessIdNumber,
        public string|null $city,
        public string|null $companyName,
        public string|null $companyLegalName,
        public mixed       $country,
        public bool|null   $crm,
        public string|null $customer,
        public string|null $customsTaxID,
        public mixed       $defaultCurrency,
        public string|null $department,
        public bool|null   $doNotCall,
        public bool|null   $doNotEmail,
        public string|null $dsfPassword,
        public bool|null   $dsfShipTo,
        public bool|null   $dsfUser,
        public string|null $dsfUserName,
        public string|null $email,
        public string|null $emailLabel,
        public string|null $businessFaxExtension,
        public string|null $businessPhoneExtension,
        public string|null $facebook,
        public bool|null   $failedGPSLookup,
        public string|null $businessFaxNumber,
        public string|null $firstName,
        public bool|null   $globalContact,
        public string|null $homeFaxNumber,
        public string|null $homePhoneNumber,
        public mixed       $id,
        public string|null $imService,
        public string|null $imUserName,
        public string|null $ioID,
        public bool|null   $jobContact,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $lastModified,
        public string|null $lastName,
        public string|null $latitude,
        public string|null $linkedIn,
        public mixed       $logo,
        public string|null $longitude,
        public string|null $lookupHint,
        public string|null $mapSiteURL,
        public mixed       $metroArea,
        public bool|null   $metroAreaForced,
        public string|null $mobilePhoneNumber,
        public bool|null   $needsInfo,
        public string|null $otherPhoneNumber,
        public string|null $paceConnectContactID,
        public string|null $businessPhoneNumber,
        public mixed       $photo,
        public string|null $position,
        public string|null $profileToken,
        public bool|null   $prospect,
        public bool|null   $residential,
        public mixed       $salesPerson,
        public mixed       $salesTax,
        public mixed       $salesTax2,
        public mixed       $salutation,
        public mixed       $shipBillToContact,
        public bool|null   $shipTo,
        public mixed       $shipVia,
        public string|null $shippingAcctNum,
        public string|null $skype,
        public mixed       $sourceOrganizationCompany,
        public mixed       $sourceType,
        public mixed       $SSOToken,
        public string|null $state,
        public mixed       $stateKey,
        public mixed       $systemUser,
        public array|null  $tags,
        public string|null $taxNumber,
        public mixed       $taxableCode,
        public int|null    $templateLine,
        public mixed       $terms,
        public string|null $title,
        public string|null $twitter,
        public bool|null   $useAlternateText,
        public string|null $vATIdNumber,
        public mixed       $vendor,
        public string|null $webSite,
        public string|null $youTube,
        public string|null $zip,
    )
    {
        //
    }

}
