<?php

namespace Ptb\Pace\Requests;

use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

class CloneObject extends Request implements HasBody
{
    use HasJsonBody;

    /**
     * The HTTP method of the request
     */
    protected Method $method = Method::POST;

    /**
     * The endpoint for the request
     */
    public function resolveEndpoint(): string
    {
        return "/CloneObject/clone{$this->type}";
    }

    /**
     * @param string $type
     * @param string $keyOfObjectToClone
     * @param string $newParentKey
     * @param array $data
     * @param string|null $newPrimaryKey
     */
    public function __construct(
        private readonly string $type,
        private readonly string $keyOfObjectToClone,
        private readonly string $newParentKey,
        private readonly array $data,
        private readonly ?string $newPrimaryKey = null,

    )
    {
        $this->query()->add('keyOfObjectToClone', $this->keyOfObjectToClone);
        $this->query()->add('newParentKey', $this->newParentKey);
        $this->query()->add('newPrimaryKey', $this->newPrimaryKey);

        $this->body()->set($this->data);
    }
}
