<?php

namespace Ptb\Pace\Models;

use Carbon\Carbon;
use Ptb\Pace\Castables\ToCarbon;
use Ptb\Pace\Query\Queryable;
use Ptb\Pace\Transformers\AsCarbon;
use Spatie\LaravelData\Attributes\WithCastable;
use Spatie\LaravelData\Attributes\WithTransformer;


class JobProduct extends \Ptb\Pace\Contracts\Model
{
    use Queryable;

    public function __construct(
        public string|null $additionalDescription,
        public float|null  $amountInvoiced,
        public float|null  $amountToInvoice,
        public bool|null   $amountToInvoiceForced,
        public bool|null   $arnSent,
        public float|null  $billedAmt,
        public float|null  $changeOrderTotal,
        public string|null $description,
        public string|null $dsfPullTicketID,
        public string|null $estimateSource,
        public float|null  $freightAmountTotal,
        public mixed       $id,
        public mixed       $images,
        public string|null $ioID,
        public mixed       $inventoryItem,
        public mixed       $invoiceUOM,
        public bool|null   $invoiceUOMForced,
        public mixed       $itemTemplate,
        public bool|null   $jdfSubmitted,
        public mixed       $job,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $lastModified,
        public string|null $lookupURL,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $lotExpirationDate,
        public float|null  $lotJobSellPricePer1000,
        public mixed       $manufacturingLocation,
        public array|null  $materialTags,
        public string|null $notes1,
        public string|null $notes2,
        public string|null $notes3,
        public string|null $notes4,
        public string|null $notes5,
        public float|null  $originalQuotedPrice,
        public bool|null   $originalQuotedPriceForced,
        public mixed       $parentJobProduct,
        public float|null  $pendingBilledAmt,
        public mixed       $poUom,
        public string|null $preferredBindingType,
        public float|null  $pricePerPOUOM,
        public string|null $printStreamPullTicketID,
        public float|null  $productValue,
        public bool|null   $proof,
        public int|null    $qtyBilled,
        public bool|null   $qtyOrderedForced,
        public int|null    $qtyPicked,
        public int|null    $qtyOrdered,
        public int|null    $qtyRemaining,
        public int|null    $qtyShipped,
        public int|null    $qtyToMfg,
        public string|null $reference1,
        public string|null $reference2,
        public mixed       $salesCategory,
        public bool|null   $salesCategoryForced,
        public bool|null   $secondSurface,
        public float|null  $sequence,
        public bool|null   $singleWebDelivery,
        public mixed       $sourceOrganizationCompany,
        public array|null  $tags,
        public mixed       $taxCategory,
        public bool|null   $taxCategoryForced,
        public int|null    $templateLine,
        public mixed       $userInterfaceSet,
        public string|null $vehicleMake,
        public string|null $vehicleModel,
        public string|null $vehicleYear,
        public string|null $vendorLotNo,
        public bool|null   $wrapRearWindow,
        public bool|null   $wrapSideWindow,
        public mixed       $wrapStyle,
    )
    {
        //
    }

}
