<?php

namespace Ptb\Pace\Models;

use Carbon\Carbon;
use Ptb\Pace\Castables\ToCarbon;
use Ptb\Pace\Query\Queryable;
use Ptb\Pace\Transformers\AsCarbon;
use Spatie\LaravelData\Attributes\WithCastable;
use Spatie\LaravelData\Attributes\WithTransformer;


class NonChargeableTime extends \Ptb\Pace\Contracts\Model
{
    use Queryable;

    public function __construct(
        public mixed       $costCenter,
        public mixed       $employeeTime,
        public Carbon|null $endDate,
        public Carbon|null $endTime,
        public mixed       $id,
        public string|null $ioID,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $lastModified,
        public mixed       $nonChargeableType,
        public string|null $note,
        public int|null    $plantManagerId,
        public mixed       $sourceOrganizationCompany,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $startDate,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $startTime,
        public array|null  $tags,
        public int|null    $templateLine,
    )
    {
        //
    }

}
