<?php

namespace Ptb\Pace\Models;

use Carbon\Carbon;
use Ptb\Pace\Castables\ToCarbon;
use Ptb\Pace\Query\Queryable;
use Ptb\Pace\Transformers\AsCarbon;
use Spatie\LaravelData\Attributes\WithCastable;
use Spatie\LaravelData\Attributes\WithTransformer;


class JobPlan extends \Ptb\Pace\Contracts\Model
{
    use Queryable;

    public function __construct(
        public bool|null   $active,
        public bool|null   $activityCodeForced,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $actualEndDate,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $actualEndTime,
        public float|null  $actualHours,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $actualStartDate,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $actualStartTime,
        public mixed       $assignedTo,
        public mixed       $component,
        public int|null    $leadTime,
        public bool|null   $deviceComplete,
        public string|null $deviceError,
        public string|null $deviceSubmissionId,
        public int|null    $earliestDateTimeIncrementCounter,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $earliestStartDate,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $earliestStartTime,
        public bool|null   $editable,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $endDate,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $endTime,
        public string|null $estimateSource,
        public float|null  $estimatedHours,
        public int|null    $estimatedProductionUnits,
        public bool|null   $finishing,
        public bool|null   $fromJobType,
        public int|null    $groupSequence,
        public bool|null   $hasBeenSubmittedToDevice,
        public mixed       $id,
        public string|null $ioID,
        public string|null $internalSplitSource,
        public int|null    $pdfSubmitTimeBuffer,
        public mixed       $job,
        public mixed       $JobPartKey,
        public mixed       $jobPartPressForm,
        public mixed       $jobShipment,
        public int|null    $lagTime,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $lastModified,
        public mixed       $linkStatus,
        public bool|null   $manual,
        public mixed       $manufacturingLocation,
        public mixed       $nextTask,
        public string|null $notes,
        public int|null    $numberOfSplits,
        public bool|null   $onScheduleBoard,
        public string|null $part,
        public float|null  $percentCompleted,
        public mixed       $activityCode,
        public float|null  $plannedHours,
        public int|null    $plantManagerId,
        public string|null $plantManagerLastMessage,
        public int|null    $planManagerMaterialConsumed,
        public string|null $planManagerRunStatus,
        public bool|null   $planManagerSynchronized,
        public mixed       $predecessor,
        public mixed       $previousTask,
        public string|null $printFlowForm,
        public string|null $printFlowId,
        public int|null    $printFlowLastRunCode,
        public int|null    $priority,
        public mixed       $proof,
        public mixed       $purchaseOrderLine,
        public int|null    $quantityToProduce,
        public string|null $quoteSource,
        public float|null  $remainingHours,
        public int|null    $rerunQuantity,
        public int|null    $run,
        public float|null  $runHours,
        public mixed       $scheduledActivity,
        public mixed       $scheduledFlag,
        public float|null  $scheduledHours,
        public float|null  $setupHours,
        public mixed       $sourceOrganizationCompany,
        public float|null  $splitFactor,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $startDate,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $startTime,
        public int|null    $status,
        public bool|null   $submittedToDevice,
        public array|null  $tags,
        public bool|null   $taskLocked,
        public int|null    $templateLine,
    )
    {
        //
    }

}
