<?php

namespace Ptb\Pace\Models;

use Carbon\Carbon;
use Ptb\Pace\Castables\ToCarbon;
use Ptb\Pace\Query\Queryable;
use Ptb\Pace\Transformers\AsCarbon;
use Spatie\LaravelData\Attributes\WithCastable;
use Spatie\LaravelData\Attributes\WithTransformer;

class EstimateMail extends \Ptb\Pace\Contracts\Model
{
    use Queryable;

    public function __construct(
        public mixed       $addressFormat,
        public bool|null   $aspectRatio,
        public bool|null   $barcode,
        public bool|null   $cassList,
        public bool|null   $cleanList,
        public string|null $coMingle,
        public mixed       $deDupeType,
        public mixed       $distribution,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $dropDate,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $dropTime,
        public bool|null   $duplicateAddress,
        public mixed       $estimatePart,
        public mixed       $extraStock,
        public string|null $fieldForDeDupe,
        public string|null $fieldsIncluded,
        public mixed       $id,
        public string|null $ioID,
        public mixed       $insertType,
        public string|null $instructions,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $lastModified,
        public mixed       $listSource,
        public mixed       $mailingAttachment,
        public mixed       $mailingClass,
        public mixed       $mailingPreparedFor,
        public mixed       $mailingSize,
        public mixed       $mailingType,
        public bool|null   $matchedMailing,
        public bool|null   $ncoaLost,
        public mixed       $permitBilling,
        public mixed       $permitPrint,
        public mixed       $permitUsed,
        public mixed       $postageType,
        public mixed       $printCase,
        public mixed       $printType,
        public bool|null   $processed,
        public bool|null   $removeDuplicateAddress,
        public bool|null   $removeInternational,
        public bool|null   $removeUndeliverable,
        public mixed       $returnAddress,
        public mixed       $returnPrint,
        public mixed       $samples,
        public mixed       $sourceOrganizationCompany,
        public array|null  $tags,
        public int|null    $templateLine,
        public int|null    $versions,
    )
    {
        //
    }

}
