<?php

namespace Ptb\Pace\Castables;

use Illuminate\Support\Arr;
use Ptb\Pace\Models\EstimateConvertToJobPart;
use Spatie\LaravelData\Casts\Cast;
use Spatie\LaravelData\Casts\Castable;
use Spatie\LaravelData\Support\Creation\CreationContext;
use Spatie\LaravelData\Support\DataProperty;
use stdClass;

class ToArrayOfEstimateConvertToJobPart implements Castable
{

    public static function dataCastUsing(...$arguments): Cast
    {
        return new class implements Cast {

            public function cast(DataProperty $property, mixed $value, array $properties, CreationContext $context): array
            {
                if ($value instanceof stdClass) {
                    return Arr::wrap(
                        value: EstimateConvertToJobPart::from((array)$value)
                    );
                }

                $values = [];
                if (is_iterable($value)) {
                    foreach ($value as $item) {
                        $values[] = EstimateConvertToJobPart::from((array)$item);
                    }
                }

                return $values;
            }
        };
    }
}