<?php

namespace Ptb\Pace\Requests;

use Saloon\Contracts\Body\HasBody;
use Saloon\Enums\Method;
use Saloon\Http\Request;
use Saloon\Traits\Body\HasJsonBody;

class DeleteObject extends Request
{
    /**
     * The HTTP method of the request
     */
    protected Method $method = Method::DELETE;

    /**
     * The endpoint for the request
     */
    public function resolveEndpoint(): string
    {
        return "/DeleteObject/DeleteObject";
    }

    protected function defaultQuery(): array
    {
        return [
            'type' => $this->type,
            'key' => $this->primaryKey,
        ];
    }

    public function __construct(
        private readonly string $type,
        private readonly string $primaryKey
    ) {
        //
    }
}
